<?php
namespace VM\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use VM\AdminBundle\Services\SsoCommunication;
use VM\AdminBundle\Services\TokensGenerator;
use VM\ApiBundle\Entity\Employee;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Entity\UserGroups;

class LoadCVData extends AbstractFixture implements OrderedFixtureInterface, ContainerAwareInterface
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $EntityManager;

    protected $url = '../../../../../web/CVData.txt';

    /**
     * {@inheritDoc}
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }


    public function load(ObjectManager $EntityManager)
    {
        ini_set('memory_limit', '2048M');
        $this->EntityManager = $EntityManager;

        $this->url = __DIR__.'/'.$this->url;

        if(!file_exists($this->url))
        {
            echo 'FILE NOT EXIST: '.$this->url;
            return array();
        }

        $count = 0;
        if (($handle = fopen($this->url, "r", 1)) !== FALSE)
        {
            while (($data = fgets($handle)) !== FALSE)
            {
                $data = explode("\t",$data);
                if(count($data) == 8)
                {

                    $this->createEmployee($data);
                    $count++;
                    if($count % 100 == 0)
                    {
                        $this->EntityManager->flush();
                        $this->EntityManager->clear();
                    }
                    for($i=0;$i<35;$i++)
                    {
                        echo chr(8);
                    }
                    echo "Imort: ".$count." employees.";
                }
            }

            fclose($handle);
        }

        $this->EntityManager->flush();
    }

    private function createEmployee($data)
    {
        $Employee = new Employee();

        $Employee->setName($data[0]);
        $Employee->setSurname($data[1]);
        $Employee->setEducation($data[2]);
        $Employee->setStudies($data[3]);
        $Employee->setDriver($data[4]);
        $Employee->setAge($data[5]);
        $Employee->setSeniority($data[6]);
        $Employee->setSalary($data[7]);
        $Employee->setIsWorker(0);

        $this->EntityManager->persist($Employee);
    }

    public function getOrder()
    {
        return 2100;
    }
}